<?php
require_once '../config.php';
if (!isLoggedIn() || !isAdmin()) redirect('../login.php');
$total_users = $conn->query("SELECT COUNT(*) as cnt FROM users WHERE is_admin=0")->fetch_assoc()['cnt'];
$total_invested = $conn->query("SELECT SUM(amount) as total FROM investments")->fetch_assoc()['total'] ?? 0;
$pending_deposits = $conn->query("SELECT COUNT(*) as cnt FROM transactions WHERE type='deposit' AND status='pending'")->fetch_assoc()['cnt'];
$pending_withdrawals = $conn->query("SELECT COUNT(*) as cnt FROM transactions WHERE type='withdrawal' AND status='pending'")->fetch_assoc()['cnt'];
$recent_users = $conn->query("SELECT * FROM users WHERE is_admin=0 ORDER BY created_at DESC LIMIT 5");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - <?= SITE_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>:root{--bg-dark:#1a1a2e;--bg-card:#16213e;--accent:#00d9ff}body{background:var(--bg-dark);color:#fff}.sidebar{background:var(--bg-card);min-height:100vh;padding:20px}.sidebar a{color:#aaa;display:block;padding:10px;border-radius:5px;text-decoration:none;margin-bottom:5px}.sidebar a:hover,.sidebar a.active{background:rgba(0,217,255,0.2);color:var(--accent)}.card{background:var(--bg-card);border:1px solid rgba(255,255,255,0.1)}.stat-card h3{color:var(--accent)}.table{color:#fff}</style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 sidebar">
                <h4 class="mb-4"><i class="fas fa-robot me-2"></i>Admin</h4>
                <a href="index.php" class="active"><i class="fas fa-home me-2"></i>Dashboard</a>
                <a href="users.php"><i class="fas fa-users me-2"></i>Users</a>
                <a href="plans.php"><i class="fas fa-layer-group me-2"></i>Plans</a>
                <a href="deposits.php"><i class="fas fa-plus-circle me-2"></i>Deposits</a>
                <a href="withdrawals.php"><i class="fas fa-minus-circle me-2"></i>Withdrawals</a>
                <a href="investments.php"><i class="fas fa-chart-line me-2"></i>Investments</a>
                <hr><a href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
            </div>
            <div class="col-md-10 p-4">
                <h4 class="mb-4">Dashboard</h4>
                <div class="row mb-4">
                    <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Total Users</small><h3><?= $total_users ?></h3></div></div>
                    <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Total Invested</small><h3><?= formatMoney($total_invested) ?></h3></div></div>
                    <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Pending Deposits</small><h3 class="text-warning"><?= $pending_deposits ?></h3></div></div>
                    <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Pending Withdrawals</small><h3 class="text-warning"><?= $pending_withdrawals ?></h3></div></div>
                </div>
                <div class="card p-3">
                    <h5 class="mb-3">Recent Users</h5>
                    <table class="table"><thead><tr><th>Username</th><th>Email</th><th>Balance</th><th>Joined</th></tr></thead><tbody>
                    <?php while($u = $recent_users->fetch_assoc()): ?>
                        <tr><td><?= htmlspecialchars($u['username']) ?></td><td><?= $u['email'] ?></td><td><?= formatMoney($u['balance']) ?></td><td><?= date('M d, Y', strtotime($u['created_at'])) ?></td></tr>
                    <?php endwhile; ?>
                    </tbody></table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>