<?php
require_once '../config.php';
if (!isLoggedIn() || !isAdmin()) redirect('../login.php');
$investments = $conn->query("SELECT i.*, u.username, p.name as plan_name FROM investments i JOIN users u ON i.user_id = u.id JOIN plans p ON i.plan_id = p.id ORDER BY i.start_date DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Investments - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>:root{--bg-dark:#1a1a2e;--bg-card:#16213e;--accent:#00d9ff}body{background:var(--bg-dark);color:#fff}.sidebar{background:var(--bg-card);min-height:100vh;padding:20px}.sidebar a{color:#aaa;display:block;padding:10px;border-radius:5px;text-decoration:none;margin-bottom:5px}.sidebar a:hover,.sidebar a.active{background:rgba(0,217,255,0.2);color:var(--accent)}.card{background:var(--bg-card);border:1px solid rgba(255,255,255,0.1)}.table{color:#fff}</style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 sidebar">
                <h4 class="mb-4"><i class="fas fa-robot me-2"></i>Admin</h4>
                <a href="index.php"><i class="fas fa-home me-2"></i>Dashboard</a>
                <a href="users.php"><i class="fas fa-users me-2"></i>Users</a>
                <a href="plans.php"><i class="fas fa-layer-group me-2"></i>Plans</a>
                <a href="deposits.php"><i class="fas fa-plus-circle me-2"></i>Deposits</a>
                <a href="withdrawals.php"><i class="fas fa-minus-circle me-2"></i>Withdrawals</a>
                <a href="investments.php" class="active"><i class="fas fa-chart-line me-2"></i>Investments</a>
                <hr><a href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
            </div>
            <div class="col-md-10 p-4">
                <h4 class="mb-4">All Investments</h4>
                <div class="card p-3">
                    <table class="table"><thead><tr><th>User</th><th>Plan</th><th>Amount</th><th>Daily %</th><th>Earned</th><th>Status</th><th>Started</th><th>Ends</th></tr></thead><tbody>
                    <?php while($i = $investments->fetch_assoc()): ?>
                        <tr><td><?= htmlspecialchars($i['username']) ?></td><td><?= $i['plan_name'] ?></td><td><?= formatMoney($i['amount']) ?></td><td><?= $i['daily_profit'] ?>%</td>
                            <td class="text-success"><?= formatMoney($i['earned']) ?></td>
                            <td><span class="badge bg-<?= $i['status']=='active'?'success':($i['status']=='completed'?'info':'danger') ?>"><?= ucfirst($i['status']) ?></span></td>
                            <td><?= date('M d, Y', strtotime($i['start_date'])) ?></td><td><?= date('M d, Y', strtotime($i['end_date'])) ?></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody></table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>