<?php
require_once '../config.php';
if (!isLoggedIn() || !isAdmin()) redirect('../login.php');
$success = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_balance'])) {
        $uid = (int)$_POST['user_id']; $amount = (float)$_POST['amount'];
        $conn->query("UPDATE users SET balance = balance + $amount WHERE id = $uid");
        $conn->query("INSERT INTO transactions (user_id, type, amount, status, description) VALUES ($uid, 'deposit', $amount, 'approved', 'Admin credit')");
        $success = "Balance added!";
    }
    if (isset($_POST['toggle_status'])) {
        $uid = (int)$_POST['user_id'];
        $user = $conn->query("SELECT status FROM users WHERE id=$uid")->fetch_assoc();
        $new_status = $user['status'] == 'active' ? 'suspended' : 'active';
        $conn->query("UPDATE users SET status = '$new_status' WHERE id = $uid");
        $success = "Status updated!";
    }
}
$users = $conn->query("SELECT * FROM users WHERE is_admin = 0 ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Users - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>:root{--bg-dark:#1a1a2e;--bg-card:#16213e;--accent:#00d9ff}body{background:var(--bg-dark);color:#fff}.sidebar{background:var(--bg-card);min-height:100vh;padding:20px}.sidebar a{color:#aaa;display:block;padding:10px;border-radius:5px;text-decoration:none;margin-bottom:5px}.sidebar a:hover,.sidebar a.active{background:rgba(0,217,255,0.2);color:var(--accent)}.card{background:var(--bg-card);border:1px solid rgba(255,255,255,0.1)}.table{color:#fff}.form-control{background:rgba(255,255,255,0.1);border:1px solid rgba(255,255,255,0.2);color:#fff}.modal-content{background:var(--bg-card)}</style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 sidebar">
                <h4 class="mb-4"><i class="fas fa-robot me-2"></i>Admin</h4>
                <a href="index.php"><i class="fas fa-home me-2"></i>Dashboard</a>
                <a href="users.php" class="active"><i class="fas fa-users me-2"></i>Users</a>
                <a href="plans.php"><i class="fas fa-layer-group me-2"></i>Plans</a>
                <a href="deposits.php"><i class="fas fa-plus-circle me-2"></i>Deposits</a>
                <a href="withdrawals.php"><i class="fas fa-minus-circle me-2"></i>Withdrawals</a>
                <a href="investments.php"><i class="fas fa-chart-line me-2"></i>Investments</a>
                <hr><a href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
            </div>
            <div class="col-md-10 p-4">
                <h4 class="mb-4">User Management</h4>
                <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
                <div class="card p-3">
                    <table class="table"><thead><tr><th>Username</th><th>Email</th><th>Balance</th><th>Total Earned</th><th>Status</th><th>Joined</th><th>Actions</th></tr></thead><tbody>
                    <?php while($u = $users->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($u['username']) ?></td><td><?= $u['email'] ?></td><td><?= formatMoney($u['balance']) ?></td>
                            <td class="text-success"><?= formatMoney($u['total_earned']) ?></td>
                            <td><span class="badge bg-<?= $u['status']=='active'?'success':'danger' ?>"><?= ucfirst($u['status']) ?></span></td>
                            <td><?= date('M d, Y', strtotime($u['created_at'])) ?></td>
                            <td>
                                <button class="btn btn-sm btn-info" onclick="addBalance(<?= $u['id'] ?>, '<?= htmlspecialchars($u['username']) ?>')"><i class="fas fa-plus"></i></button>
                                <form method="POST" style="display:inline"><input type="hidden" name="user_id" value="<?= $u['id'] ?>"><button name="toggle_status" class="btn btn-sm btn-<?= $u['status']=='active'?'warning':'success' ?>"><?= $u['status']=='active'?'Ban':'Activate' ?></button></form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody></table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="addBalanceModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content p-4">
        <h5 class="mb-3">Add Balance to <span id="modal_username"></span></h5>
        <form method="POST"><input type="hidden" name="user_id" id="modal_user_id">
            <div class="mb-3"><label class="form-label">Amount ($)</label><input type="number" name="amount" class="form-control" step="0.01" required></div>
            <button type="submit" name="add_balance" class="btn btn-primary w-100">Add Balance</button>
        </form>
    </div></div></div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>function addBalance(id, username) { document.getElementById('modal_user_id').value = id; document.getElementById('modal_username').textContent = username; new bootstrap.Modal(document.getElementById('addBalanceModal')).show(); }</script>
</body>
</html>