<?php
require_once '../config.php';
if (!isLoggedIn() || !isAdmin()) redirect('../login.php');
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = (int)$_POST['txn_id']; $action = sanitize($_POST['action']);
    $txn = $conn->query("SELECT * FROM transactions WHERE id=$id")->fetch_assoc();
    if ($action == 'approve') {
        $conn->query("UPDATE transactions SET status='approved' WHERE id=$id");
        $conn->query("UPDATE users SET balance = balance - {$txn['amount']} WHERE id={$txn['user_id']}");
    } else { $conn->query("UPDATE transactions SET status='rejected' WHERE id=$id"); }
}
$withdrawals = $conn->query("SELECT t.*, u.username, u.email FROM transactions t JOIN users u ON t.user_id = u.id WHERE t.type='withdrawal' ORDER BY CASE WHEN t.status='pending' THEN 0 ELSE 1 END, t.created_at DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdrawals - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>:root{--bg-dark:#1a1a2e;--bg-card:#16213e;--accent:#00d9ff}body{background:var(--bg-dark);color:#fff}.sidebar{background:var(--bg-card);min-height:100vh;padding:20px}.sidebar a{color:#aaa;display:block;padding:10px;border-radius:5px;text-decoration:none;margin-bottom:5px}.sidebar a:hover,.sidebar a.active{background:rgba(0,217,255,0.2);color:var(--accent)}.card{background:var(--bg-card);border:1px solid rgba(255,255,255,0.1)}.table{color:#fff}</style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 sidebar">
                <h4 class="mb-4"><i class="fas fa-robot me-2"></i>Admin</h4>
                <a href="index.php"><i class="fas fa-home me-2"></i>Dashboard</a>
                <a href="users.php"><i class="fas fa-users me-2"></i>Users</a>
                <a href="plans.php"><i class="fas fa-layer-group me-2"></i>Plans</a>
                <a href="deposits.php"><i class="fas fa-plus-circle me-2"></i>Deposits</a>
                <a href="withdrawals.php" class="active"><i class="fas fa-minus-circle me-2"></i>Withdrawals</a>
                <a href="investments.php"><i class="fas fa-chart-line me-2"></i>Investments</a>
                <hr><a href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
            </div>
            <div class="col-md-10 p-4">
                <h4 class="mb-4">Withdrawal Requests</h4>
                <div class="card p-3">
                    <table class="table"><thead><tr><th>User</th><th>Amount</th><th>Wallet</th><th>Status</th><th>Date</th><th>Actions</th></tr></thead><tbody>
                    <?php while($w = $withdrawals->fetch_assoc()): ?>
                        <tr><td><?= htmlspecialchars($w['username']) ?></td><td><?= formatMoney($w['amount']) ?></td><td><small><?= htmlspecialchars($w['description']) ?></small></td>
                            <td><span class="badge bg-<?= $w['status']=='approved'?'success':($w['status']=='pending'?'warning':'danger') ?>"><?= ucfirst($w['status']) ?></span></td>
                            <td><?= date('M d, Y H:i', strtotime($w['created_at'])) ?></td>
                            <td><?php if ($w['status'] == 'pending'): ?><form method="POST" style="display:inline"><input type="hidden" name="txn_id" value="<?= $w['id'] ?>"><button name="action" value="approve" class="btn btn-sm btn-success">Approve</button><button name="action" value="reject" class="btn btn-sm btn-danger">Reject</button></form><?php endif; ?></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody></table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>