<?php
require_once 'config.php';
if (!isLoggedIn()) redirect('login.php');
$user_id = $_SESSION['user_id'];
$user = $conn->query("SELECT * FROM users WHERE id=$user_id")->fetch_assoc();
$investments = $conn->query("SELECT i.*, p.name as plan_name FROM investments i JOIN plans p ON i.plan_id = p.id WHERE i.user_id=$user_id ORDER BY i.start_date DESC");
$trades = $conn->query("SELECT * FROM trades WHERE user_id=$user_id ORDER BY created_at DESC LIMIT 10");
$total_invested = $conn->query("SELECT SUM(amount) as total FROM investments WHERE user_id=$user_id AND status='active'")->fetch_assoc()['total'] ?? 0;
$active_count = $conn->query("SELECT COUNT(*) as cnt FROM investments WHERE user_id=$user_id AND status='active'")->fetch_assoc()['cnt'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?= SITE_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-dark: #1a1a2e; --bg-card: #16213e; --accent: #00d9ff; }
        body { background: var(--bg-dark); color: #fff; min-height: 100vh; }
        .navbar { background: var(--bg-card) !important; }
        .card { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); }
        .stat-card { border-left: 4px solid var(--accent); }
        .stat-card h3 { color: var(--accent); }
        .btn-primary { background: linear-gradient(45deg, #00d9ff, #0066ff); border: none; }
        .table { color: #fff; }
        .trade-profit { color: #00c853; }
        .trade-loss { color: #ff5252; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark mb-4">
        <div class="container">
            <a class="navbar-brand" href="#"><i class="fas fa-robot me-2"></i><?= SITE_NAME ?></a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="dashboard.php">Dashboard</a>
                <a class="nav-link" href="invest.php">Invest</a>
                <a class="nav-link" href="deposit.php">Deposit</a>
                <a class="nav-link" href="withdraw.php">Withdraw</a>
                <a class="nav-link" href="logout.php">Logout</a>
            </div>
        </div>
    </nav>
    <div class="container">
        <h4 class="mb-4">Welcome back, <?= htmlspecialchars($user['username']) ?>!</h4>
        <div class="row mb-4">
            <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Account Balance</small><h3><?= formatMoney($user['balance']) ?></h3></div></div>
            <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Total Invested</small><h3><?= formatMoney($total_invested) ?></h3></div></div>
            <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Total Earned</small><h3><?= formatMoney($user['total_earned']) ?></h3></div></div>
            <div class="col-md-3"><div class="card stat-card p-3"><small class="text-muted">Active Plans</small><h3><?= $active_count ?></h3></div></div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="card p-3 mb-4">
                    <h5 class="mb-3"><i class="fas fa-chart-line me-2"></i>Active Investments</h5>
                    <?php if ($investments->num_rows > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead><tr><th>Plan</th><th>Amount</th><th>Daily %</th><th>Earned</th></tr></thead>
                                <tbody>
                                <?php while($inv = $investments->fetch_assoc()): ?>
                                    <tr><td><?= $inv['plan_name'] ?></td><td><?= formatMoney($inv['amount']) ?></td><td><?= $inv['daily_profit'] ?>%</td><td class="trade-profit"><?= formatMoney($inv['earned']) ?></td></tr>
                                <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No active investments. <a href="invest.php">Start investing now!</a></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card p-3 mb-4">
                    <h5 class="mb-3"><i class="fas fa-exchange-alt me-2"></i>Recent Bot Trades</h5>
                    <?php if ($trades->num_rows > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead><tr><th>Pair</th><th>Type</th><th>Amount</th><th>Profit</th></tr></thead>
                                <tbody>
                                <?php while($trade = $trades->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= $trade['pair'] ?></td>
                                        <td><span class="badge <?= $trade['type']=='buy'?'bg-success':'bg-danger' ?>"><?= strtoupper($trade['type']) ?></span></td>
                                        <td><?= formatMoney($trade['amount']) ?></td>
                                        <td class="<?= $trade['profit']>=0?'trade-profit':'trade-loss' ?>"><?= $trade['profit']>=0?'+':'' ?><?= formatMoney($trade['profit']) ?></td>
                                    </tr>
                                <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No trades yet. Bot will start trading once you invest.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>