<?php
require_once 'config.php';
if (!isLoggedIn()) redirect('login.php');
$user_id = $_SESSION['user_id'];
$user = $conn->query("SELECT * FROM users WHERE id=$user_id")->fetch_assoc();
$plans = $conn->query("SELECT * FROM plans WHERE status='active' ORDER BY min_amount ASC");
$error = $success = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $plan_id = (int)$_POST['plan_id'];
    $amount = (float)$_POST['amount'];
    $plan = $conn->query("SELECT * FROM plans WHERE id=$plan_id AND status='active'")->fetch_assoc();
    if (!$plan) { $error = "Invalid plan selected"; }
    elseif ($amount < $plan['min_amount'] || $amount > $plan['max_amount']) { $error = "Amount must be between " . formatMoney($plan['min_amount']) . " and " . formatMoney($plan['max_amount']); }
    elseif ($user['balance'] < $amount) { $error = "Insufficient balance. Please deposit first."; }
    else {
        $daily_profit = $plan['daily_profit'];
        $total_return = $amount + ($amount * $daily_profit / 100 * $plan['duration_days']);
        $end_date = date('Y-m-d H:i:s', strtotime("+{$plan['duration_days']} days"));
        $conn->begin_transaction();
        try {
            $conn->query("UPDATE users SET balance = balance - $amount WHERE id=$user_id");
            $conn->query("INSERT INTO investments (user_id, plan_id, amount, daily_profit, total_return, end_date) VALUES ($user_id, $plan_id, $amount, $daily_profit, $total_return, '$end_date')");
            $conn->query("INSERT INTO transactions (user_id, type, amount, status, description) VALUES ($user_id, 'investment', $amount, 'approved', 'Investment in {$plan['name']} plan')");
            $conn->commit();
            $success = "Investment successful! Bot trading will begin shortly.";
            $user['balance'] -= $amount;
        } catch (Exception $e) { $conn->rollback(); $error = "Investment failed. Please try again."; }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invest - <?= SITE_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-dark: #1a1a2e; --bg-card: #16213e; --accent: #00d9ff; }
        body { background: var(--bg-dark); color: #fff; min-height: 100vh; }
        .navbar { background: var(--bg-card) !important; }
        .card { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); }
        .plan-card { transition: transform 0.3s; cursor: pointer; }
        .plan-card:hover { transform: translateY(-5px); border-color: var(--accent); }
        .plan-card.selected { border: 2px solid var(--accent); }
        .btn-primary { background: linear-gradient(45deg, #00d9ff, #0066ff); border: none; }
        .form-control { background: rgba(255,255,255,0.1); border: 1px solid rgba(255,255,255,0.2); color: #fff; }
        .form-control:focus { background: rgba(255,255,255,0.15); color: #fff; }
        .profit-badge { background: linear-gradient(45deg, #00c853, #00e676); padding: 5px 15px; border-radius: 20px; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark mb-4">
        <div class="container">
            <a class="navbar-brand" href="#"><i class="fas fa-robot me-2"></i><?= SITE_NAME ?></a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="dashboard.php">Dashboard</a>
                <a class="nav-link active" href="invest.php">Invest</a>
                <a class="nav-link" href="deposit.php">Deposit</a>
                <a class="nav-link" href="withdraw.php">Withdraw</a>
                <a class="nav-link" href="logout.php">Logout</a>
            </div>
        </div>
    </nav>
    <div class="container">
        <h4 class="mb-2">Investment Plans</h4>
        <p class="text-muted mb-4">Your Balance: <strong class="text-info"><?= formatMoney($user['balance']) ?></strong></p>
        <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
        <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
        <form method="POST" id="investForm">
            <input type="hidden" name="plan_id" id="plan_id">
            <div class="row mb-4">
                <?php while($plan = $plans->fetch_assoc()): ?>
                <div class="col-md-3 mb-3">
                    <div class="card plan-card p-3 text-center" data-plan="<?= $plan['id'] ?>" data-min="<?= $plan['min_amount'] ?>" data-max="<?= $plan['max_amount'] ?>">
                        <h5 class="text-info"><?= $plan['name'] ?></h5>
                        <div class="profit-badge my-3"><?= $plan['daily_profit'] ?>% Daily</div>
                        <p class="mb-1"><small>Min: <?= formatMoney($plan['min_amount']) ?></small></p>
                        <p class="mb-1"><small>Max: <?= formatMoney($plan['max_amount']) ?></small></p>
                        <p class="mb-0"><small>Duration: <?= $plan['duration_days'] ?> days</small></p>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card p-4">
                        <h5 class="mb-3">Investment Amount</h5>
                        <div class="mb-3"><input type="number" name="amount" id="amount" class="form-control form-control-lg" placeholder="Enter amount" step="0.01" required></div>
                        <button type="submit" class="btn btn-primary btn-lg w-100">Invest Now</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script>
        document.querySelectorAll('.plan-card').forEach(card => {
            card.addEventListener('click', function() {
                document.querySelectorAll('.plan-card').forEach(c => c.classList.remove('selected'));
                this.classList.add('selected');
                document.getElementById('plan_id').value = this.dataset.plan;
                document.getElementById('amount').min = this.dataset.min;
                document.getElementById('amount').max = this.dataset.max;
                document.getElementById('amount').placeholder = 'Enter amount (' + this.dataset.min + ' - ' + this.dataset.max + ')';
            });
        });
    </script>
</body>
</html>